<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class LokasiKantor extends Model
{
    protected $table = 'lokasi_kantor';

    protected $fillable = [
        'nama_lokasi',
        'latitude',
        'longitude',
        'radius',
    ];

    public static function isWithinRadius($userLat, $userLong)
    {
        $lokasi = self::first();

        if (!$lokasi) return false;

        $distance = self::calculateDistance(
            $lokasi->latitude,
            $lokasi->longitude,
            $userLat,
            $userLong
        );

        return $distance <= $lokasi->radius;
    }

    private static function calculateDistance($lat1, $lon1, $lat2, $lon2)
    {
        $earthRadius = 6371000;

        $latFrom = deg2rad($lat1);
        $lonFrom = deg2rad($lon1);
        $latTo = deg2rad($lat2);
        $lonTo = deg2rad($lon2);

        $latDelta = $latTo - $latFrom;
        $lonDelta = $lonTo - $lonFrom;

        $angle = 2 * asin(sqrt(pow(sin($latDelta / 2), 2) +
            cos($latFrom) * cos($latTo) * pow(sin($lonDelta / 2), 2)));

        return $angle * $earthRadius;
    }
}
